<?php

namespace John\JohnPackage\Repositories\Presenter;

use League\Fractal\TransformerAbstract;
use Hashids;

class ProjectTransformer extends TransformerAbstract
{
    public function transform(\John\JohnPackage\Models\Project $project)
    {
        return [
            'id'                => $project->getRouteKey(),
            'key'               => [
                'public'    => $project->getPublicKey(),
                'route'     => $project->getRouteKey(),
            ], 
            'name'              => $project->name,
            'url'               => [
                'public'    => trans_url('john_package/'.$project->getPublicKey()),
                'user'      => guard_url('john_package/project/'.$project->getRouteKey()),
            ], 
            'status'            => trans('app.'.$project->status),
            'created_at'        => format_date($project->created_at),
            'updated_at'        => format_date($project->updated_at),
        ];
    }
}