<?php

namespace John\JohnPackage\Workflow;

use Exception;
use Litepie\Workflow\Exceptions\WorkflowActionNotPerformedException;

use John\JohnPackage\Models\Project;

class ProjectAction
{
    /**
     * Perform the complete action.
     *
     * @param Project $project
     *
     * @return Project
     */
    public function complete(Project $project)
    {
        try {
            $project->status = 'complete';
            return $project->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the verify action.
     *
     * @param Project $project
     *
     * @return Project
     */public function verify(Project $project)
    {
        try {
            $project->status = 'verify';
            return $project->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the approve action.
     *
     * @param Project $project
     *
     * @return Project
     */public function approve(Project $project)
    {
        try {
            $project->status = 'approve';
            return $project->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the publish action.
     *
     * @param Project $project
     *
     * @return Project
     */public function publish(Project $project)
    {
        try {
            $project->status = 'publish';
            return $project->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the archive action.
     *
     * @param Project $project
     *
     * @return Project
     */
    public function archive(Project $project)
    {
        try {
            $project->status = 'archive';
            return $project->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }

    /**
     * Perform the unpublish action.
     *
     * @param Project $project
     *
     * @return Project
     */
    public function unpublish(Project $project)
    {
        try {
            $project->status = 'unpublish';
            return $project->save();
        } catch (Exception $e) {
            throw new WorkflowActionNotPerformedException();
        }
    }
}
