<?php

namespace John\JohnPackage\Workflow;

use John\JohnPackage\Models\Project;
use John\JohnPackage\Notifications\ProjectWorkflow as ProjectNotifyer;
use Notification;

class ProjectNotification
{

    /**
     * Send the notification to the users after complete.
     *
     * @param Project $project
     *
     * @return void
     */
    public function complete(Project $project)
    {
        return Notification::send($project->user, new ProjectNotifyer($project, 'complete'));;
    }

    /**
     * Send the notification to the users after verify.
     *
     * @param Project $project
     *
     * @return void
     */
    public function verify(Project $project)
    {
        return Notification::send($project->user, new ProjectNotifyer($project, 'verify'));;
    }

    /**
     * Send the notification to the users after approve.
     *
     * @param Project $project
     *
     * @return void
     */
    public function approve(Project $project)
    {
        return Notification::send($project->user, new ProjectNotifyer($project, 'approve'));;

    }

    /**
     * Send the notification to the users after publish.
     *
     * @param Project $project
     *
     * @return void
     */
    public function publish(Project $project)
    {
        return Notification::send($project->user, new ProjectNotifyer($project, 'publish'));;
    }

    /**
     * Send the notification to the users after archive.
     *
     * @param Project $project
     *
     * @return void
     */
    public function archive(Project $project)
    {
        return Notification::send($project->user, new ProjectNotifyer($project, 'archive'));;

    }

    /**
     * Send the notification to the users after unpublish.
     *
     * @param Project $project
     *
     * @return void
     */
    public function unpublish(Project $project)
    {
        return Notification::send($project->user, new ProjectNotifyer($project, 'unpublish'));;

    }
}
