<?php

namespace John\JohnPackage\Workflow;

use John\JohnPackage\Models\Project;
use Validator;

class ProjectValidator
{

    /**
     * Determine if the given project is valid for complete status.
     *
     * @param Project $project
     *
     * @return bool / Validator
     */
    public function complete(Project $project)
    {
        return Validator::make($project->toArray(), [
            'title' => 'required|min:15',
        ]);
    }

    /**
     * Determine if the given project is valid for verify status.
     *
     * @param Project $project
     *
     * @return bool / Validator
     */
    public function verify(Project $project)
    {
        return Validator::make($project->toArray(), [
            'title'  => 'required|min:15',
            'status' => 'in:complete',
        ]);
    }

    /**
     * Determine if the given project is valid for approve status.
     *
     * @param Project $project
     *
     * @return bool / Validator
     */
    public function approve(Project $project)
    {
        return Validator::make($project->toArray(), [
            'title'  => 'required|min:15',
            'status' => 'in:verify',
        ]);

    }

    /**
     * Determine if the given project is valid for publish status.
     *
     * @param Project $project
     *
     * @return bool / Validator
     */
    public function publish(Project $project)
    {
        return Validator::make($project->toArray(), [
            'title'       => 'required|min:15',
            'description' => 'required|min:50',
            'status'      => 'in:approve,archive,unpublish',
        ]);

    }

    /**
     * Determine if the given project is valid for archive status.
     *
     * @param Project $project
     *
     * @return bool / Validator
     */
    public function archive(Project $project)
    {
        return Validator::make($project->toArray(), [
            'title'       => 'required|min:15',
            'description' => 'required|min:50',
            'status'      => 'in:approve,publish,unpublish',
        ]);

    }

    /**
     * Determine if the given project is valid for unpublish status.
     *
     * @param Project $project
     *
     * @return bool / Validator
     */
    public function unpublish(Project $project)
    {
        return Validator::make($project->toArray(), [
            'title'       => 'required|min:15',
            'description' => 'required|min:50',
            'status'      => 'in:publish',
        ]);

    }
}
