<?php

namespace Litecms\Practice1\Http\Controllers;

use App\Http\Controllers\PublicController as BaseController;
use Litecms\Practice1\Interfaces\Practice1RepositoryInterface;

class Practice1PublicController extends BaseController
{
    // use Practice1Workflow;

    /**
     * Constructor.
     *
     * @param type \Litecms\Practice1\Interfaces\Practice1RepositoryInterface $practice1
     *
     * @return type
     */
    public function __construct(Practice1RepositoryInterface $practice1)
    {
        $this->repository = $practice1;
        parent::__construct();
    }

    /**
     * Show practice1's list.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function index()
    {
        $practice1s = $this->repository
        ->pushCriteria(app('Litepie\Repository\Criteria\RequestCriteria'))
        ->scopeQuery(function($query){
            return $query->orderBy('id','DESC');
        })->paginate();


        return $this->response->title(trans('$practice1::$practice1.names'))
            ->view('$practice1::public.practice1.index')
            ->data(compact('$practice1s'))
            ->output();
    }

    /**
     * Show practice1's list based on a type.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function list($type = null)
    {
        $practice1s = $this->repository
        ->pushCriteria(app('Litepie\Repository\Criteria\RequestCriteria'))
        ->scopeQuery(function($query){
            return $query->orderBy('id','DESC');
        })->paginate();


        return $this->response->title(trans('$practice1::$practice1.names'))
            ->view('$practice1::public.practice1.index')
            ->data(compact('$practice1s'))
            ->output();
    }

    /**
     * Show practice1.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function show($slug)
    {
        $practice1 = $this->repository->scopeQuery(function($query) use ($slug) {
            return $query->orderBy('id','DESC')
                         ->where('slug', $slug);
        })->first(['*']);

        return $this->response->title($$practice1->name . trans('$practice1::$practice1.name'))
            ->view('$practice1::public.practice1.show')
            ->data(compact('$practice1'))
            ->output();
    }

}
