<?php

namespace Litecms\Practice1\Http\Controllers;

use App\Http\Controllers\ResourceController as BaseController;
use Form;
use Litecms\Practice1\Http\Requests\Practice1Request;
use Litecms\Practice1\Interfaces\Practice1RepositoryInterface;
use Litecms\Practice1\Models\Practice1;

/**
 * Resource controller class for practice1.
 */
class Practice1ResourceController extends BaseController
{

    /**
     * Initialize practice1 resource controller.
     *
     * @param type Practice1RepositoryInterface $practice1
     *
     * @return null
     */
    public function __construct(Practice1RepositoryInterface $practice1)
    {
        parent::__construct();
        $this->repository = $practice1;
        $this->repository
            ->pushCriteria(\Litepie\Repository\Criteria\RequestCriteria::class)
            ->pushCriteria(\Litecms\Practice1\Repositories\Criteria\Practice1ResourceCriteria::class);
    }

    /**
     * Display a list of practice1.
     *
     * @return Response
     */
    public function index(Practice1Request $request)
    {
        $view = $this->response->theme->listView();

        if ($this->response->typeIs('json')) {
            $function = camel_case('get-' . $view);
            return $this->repository
                ->setPresenter(\Litecms\Practice1\Repositories\Presenter\Practice1Presenter::class)
                ->$function();
        }

        $practice1s = $this->repository->paginate();

        return $this->response->title(trans('practice1::practice1.names'))
            ->view('practice1::practice1.index', true)
            ->data(compact('practice1s'))
            ->output();
    }

    /**
     * Display practice1.
     *
     * @param Request $request
     * @param Model   $practice1
     *
     * @return Response
     */
    public function show(Practice1Request $request, Practice1 $practice1)
    {

        if ($practice1->exists) {
            $view = 'practice1::practice1.show';
        } else {
            $view = 'practice1::practice1.new';
        }

        return $this->response->title(trans('app.view') . ' ' . trans('practice1::practice1.name'))
            ->data(compact('practice1'))
            ->view($view, true)
            ->output();
    }

    /**
     * Show the form for creating a new practice1.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function create(Practice1Request $request)
    {

        $practice1 = $this->repository->newInstance([]);
        return $this->response->title(trans('app.new') . ' ' . trans('practice1::practice1.name')) 
            ->view('practice1::practice1.create', true) 
            ->data(compact('practice1'))
            ->output();
    }

    /**
     * Create new practice1.
     *
     * @param Request $request
     *
     * @return Response
     */
    public function store(Practice1Request $request)
    {
        try {
            $attributes              = $request->all();
            $attributes['user_id']   = user_id();
            $attributes['user_type'] = user_type();
            $practice1                 = $this->repository->create($attributes);

            return $this->response->message(trans('messages.success.created', ['Module' => trans('practice1::practice1.name')]))
                ->code(204)
                ->status('success')
                ->url(guard_url('practice1/practice1/' . $practice1->getRouteKey()))
                ->redirect();
        } catch (Exception $e) {
            return $this->response->message($e->getMessage())
                ->code(400)
                ->status('error')
                ->url(guard_url('/practice1/practice1'))
                ->redirect();
        }

    }

    /**
     * Show practice1 for editing.
     *
     * @param Request $request
     * @param Model   $practice1
     *
     * @return Response
     */
    public function edit(Practice1Request $request, Practice1 $practice1)
    {
        return $this->response->title(trans('app.edit') . ' ' . trans('practice1::practice1.name'))
            ->view('practice1::practice1.edit', true)
            ->data(compact('practice1'))
            ->output();
    }

    /**
     * Update the practice1.
     *
     * @param Request $request
     * @param Model   $practice1
     *
     * @return Response
     */
    public function update(Practice1Request $request, Practice1 $practice1)
    {
        try {
            $attributes = $request->all();

            $practice1->update($attributes);
            return $this->response->message(trans('messages.success.updated', ['Module' => trans('practice1::practice1.name')]))
                ->code(204)
                ->status('success')
                ->url(guard_url('practice1/practice1/' . $practice1->getRouteKey()))
                ->redirect();
        } catch (Exception $e) {
            return $this->response->message($e->getMessage())
                ->code(400)
                ->status('error')
                ->url(guard_url('practice1/practice1/' . $practice1->getRouteKey()))
                ->redirect();
        }

    }

    /**
     * Remove the practice1.
     *
     * @param Model   $practice1
     *
     * @return Response
     */
    public function destroy(Practice1Request $request, Practice1 $practice1)
    {
        try {

            $practice1->delete();
            return $this->response->message(trans('messages.success.deleted', ['Module' => trans('practice1::practice1.name')]))
                ->code(202)
                ->status('success')
                ->url(guard_url('practice1/practice1/0'))
                ->redirect();

        } catch (Exception $e) {

            return $this->response->message($e->getMessage())
                ->code(400)
                ->status('error')
                ->url(guard_url('practice1/practice1/' . $practice1->getRouteKey()))
                ->redirect();
        }

    }

    /**
     * Remove multiple practice1.
     *
     * @param Model   $practice1
     *
     * @return Response
     */
    public function delete(Practice1Request $request, $type)
    {
        try {
            $ids = hashids_decode($request->input('ids'));

            if ($type == 'purge') {
                $this->repository->purge($ids);
            } else {
                $this->repository->delete($ids);
            }

            return $this->response->message(trans('messages.success.deleted', ['Module' => trans('practice1::practice1.name')]))
                ->status("success")
                ->code(202)
                ->url(guard_url('practice1/practice1'))
                ->redirect();

        } catch (Exception $e) {

            return $this->response->message($e->getMessage())
                ->status("error")
                ->code(400)
                ->url(guard_url('/practice1/practice1'))
                ->redirect();
        }

    }

    /**
     * Restore deleted practice1s.
     *
     * @param Model   $practice1
     *
     * @return Response
     */
    public function restore(Practice1Request $request)
    {
        try {
            $ids = hashids_decode($request->input('ids'));
            $this->repository->restore($ids);

            return $this->response->message(trans('messages.success.restore', ['Module' => trans('practice1::practice1.name')]))
                ->status("success")
                ->code(202)
                ->url(guard_url('/practice1/practice1'))
                ->redirect();

        } catch (Exception $e) {

            return $this->response->message($e->getMessage())
                ->status("error")
                ->code(400)
                ->url(guard_url('/practice1/practice1/'))
                ->redirect();
        }

    }

}
