<?php

namespace Litecms\Practice1\Policies;

use Litepie\User\Contracts\UserPolicy;
use Litecms\Practice1\Models\Practice1;

class Practice1Policy
{

    /**
     * Determine if the given user can view the practice1.
     *
     * @param UserPolicy $user
     * @param Practice1 $practice1
     *
     * @return bool
     */
    public function view(UserPolicy $user, Practice1 $practice1)
    {
        if ($user->canDo('practice1.practice1.view') && $user->isAdmin()) {
            return true;
        }

        return $practice1->user_id == user_id() && $practice1->user_type == user_type();
    }

    /**
     * Determine if the given user can create a practice1.
     *
     * @param UserPolicy $user
     * @param Practice1 $practice1
     *
     * @return bool
     */
    public function create(UserPolicy $user)
    {
        return  $user->canDo('practice1.practice1.create');
    }

    /**
     * Determine if the given user can update the given practice1.
     *
     * @param UserPolicy $user
     * @param Practice1 $practice1
     *
     * @return bool
     */
    public function update(UserPolicy $user, Practice1 $practice1)
    {
        if ($user->canDo('practice1.practice1.edit') && $user->isAdmin()) {
            return true;
        }

        return $practice1->user_id == user_id() && $practice1->user_type == user_type();
    }

    /**
     * Determine if the given user can delete the given practice1.
     *
     * @param UserPolicy $user
     * @param Practice1 $practice1
     *
     * @return bool
     */
    public function destroy(UserPolicy $user, Practice1 $practice1)
    {
        return $practice1->user_id == user_id() && $practice1->user_type == user_type();
    }

    /**
     * Determine if the given user can verify the given practice1.
     *
     * @param UserPolicy $user
     * @param Practice1 $practice1
     *
     * @return bool
     */
    public function verify(UserPolicy $user, Practice1 $practice1)
    {
        if ($user->canDo('practice1.practice1.verify')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given practice1.
     *
     * @param UserPolicy $user
     * @param Practice1 $practice1
     *
     * @return bool
     */
    public function approve(UserPolicy $user, Practice1 $practice1)
    {
        if ($user->canDo('practice1.practice1.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $user    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($user, $ability)
    {
        if ($user->isSuperuser()) {
            return true;
        }
    }
}
