<?php

namespace Litecms\Practice1\Providers;

use Illuminate\Support\ServiceProvider;

class Practice1ServiceProvider extends ServiceProvider
{
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = false;

    /**
     * Bootstrap the application events.
     *
     * @return void
     */
    public function boot()
    {
        // Load view
        $this->loadViewsFrom(__DIR__ . '/../../resources/views', 'practice1');

        // Load translation
        $this->loadTranslationsFrom(__DIR__ . '/../../resources/lang', 'practice1');

        // Load migrations
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');

        // Call pblish redources function
        $this->publishResources();

    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        // Bind facade
        $this->app->bind('litecms.practice1', function ($app) {
            return $this->app->make('Litecms\Practice1\Practice1');
        });

                // Bind Practice1 to repository
        $this->app->bind(
            'Litecms\Practice1\Interfaces\Practice1RepositoryInterface',
            \Litecms\Practice1\Repositories\Eloquent\Practice1Repository::class
        );

        $this->app->register(\Litecms\Practice1\Providers\AuthServiceProvider::class);
        
        $this->app->register(\Litecms\Practice1\Providers\RouteServiceProvider::class);
                
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return ['litecms.practice1'];
    }

    /**
     * Publish resources.
     *
     * @return void
     */
    private function publishResources()
    {
        // Publish configuration file
        $this->publishes([__DIR__ . '/../../config/config.php' => config_path('litecms/practice1.php')], 'config');

        // Publish admin view
        $this->publishes([__DIR__ . '/../../resources/views' => base_path('resources/views/vendor/practice1')], 'view');

        // Publish language files
        $this->publishes([__DIR__ . '/../../resources/lang' => base_path('resources/lang/vendor/practice1')], 'lang');

        // Publish public files and assets.
        $this->publishes([__DIR__ . '/public/' => public_path('/')], 'public');
    }
}
