<?php

namespace Litecms\Practice1\Repositories\Presenter;

use League\Fractal\TransformerAbstract;
use Hashids;

class Practice1Transformer extends TransformerAbstract
{
    public function transform(\Litecms\Practice1\Models\Practice1 $practice1)
    {
        return [
            'id'                => $practice1->getRouteKey(),
            'key'               => [
                'public'    => $practice1->getPublicKey(),
                'route'     => $practice1->getRouteKey(),
            ], 
            'name'              => $practice1->name,
            'image'             => $practice1->image,
            'habbits'           => $practice1->habbits,
            'url'               => [
                'public'    => trans_url('practice1/'.$practice1->getPublicKey()),
                'user'      => guard_url('practice1/practice1/'.$practice1->getRouteKey()),
            ], 
            'status'            => trans('app.'.$practice1->status),
            'created_at'        => format_date($practice1->created_at),
            'updated_at'        => format_date($practice1->updated_at),
        ];
    }
}