<?php


return  
    [
        'model' => [
            'model' => \Projects\Project\Models\Project::class,
            'repository' => \Projects\Project\Repositories\Eloquent\ProjectRepository::class,
            'table' => 'projects',
            'hidden'=> [],
            'visible' => [],
            'guarded' => ['*'],
            'slugs' => ['slug' => 'name'],
            'dates' => ['deleted_at', 'createdat', 'updated_at'],
            'appends' => [],
            'fillable' => ['id',  'client_id',  'project_manager_id',  'status_id',  'name',  'path',  'language',  'domain',  'description',  'duration',  'deadline',  'created_at',  'modified_at',  ')',  '),',  'id),',  'client_id),',  'project_manager_id),'],
            'translatables' => [],
            'upload_folder' => 'project/project',
            'uploads' => [
            /*
                    'images' => [
                        'count' => 10,
                        'type'  => 'image',
                    ],
                    'file' => [
                        'count' => 1,
                        'type'  => 'file',
                    ],
            */
            ],

            'casts' => [
            /*
                'images'    => 'array',
                'file'      => 'array',
            */
            ],

            'revision' => [],
            'perPage' => '20',
            'search'        => [
                'name'  => 'like',
                'status',
            ]
        ],

        'search' => [
            
        ],

        'list' => [
            "client_id" => [
                "key" => "client_id", 
                "type" => "text", 
                "label" => 'project::project.label.client_id', 
                'sort' => true,
                'roles' => [],
            ],
            "project_manager_id" => [
                "key" => "project_manager_id", 
                "type" => "text", 
                "label" => 'project::project.label.project_manager_id', 
                'sort' => true,
                'roles' => [],
            ],
            "status_id" => [
                "key" => "status_id", 
                "type" => "text", 
                "label" => 'project::project.label.status_id', 
                'sort' => true,
                'roles' => [],
            ],
            "name" => [
                "key" => "name", 
                "type" => "text", 
                "label" => 'project::project.label.name', 
                'sort' => true,
                'roles' => [],
            ],
            "path" => [
                "key" => "path", 
                "type" => "text", 
                "label" => 'project::project.label.path', 
                'sort' => true,
                'roles' => [],
            ],
            "language" => [
                "key" => "language", 
                "type" => "text", 
                "label" => 'project::project.label.language', 
                'sort' => true,
                'roles' => [],
            ],
            "domain" => [
                "key" => "domain", 
                "type" => "text", 
                "label" => 'project::project.label.domain', 
                'sort' => true,
                'roles' => [],
            ],
            "description" => [
                "key" => "description", 
                "type" => "text", 
                "label" => 'project::project.label.description', 
                'sort' => true,
                'roles' => [],
            ],
            "duration" => [
                "key" => "duration", 
                "type" => "text", 
                "label" => 'project::project.label.duration', 
                'sort' => true,
                'roles' => [],
            ],
            "deadline" => [
                "key" => "deadline", 
                "type" => "text", 
                "label" => 'project::project.label.deadline', 
                'sort' => true,
                'roles' => [],
            ],
            "modified_at" => [
                "key" => "modified_at", 
                "type" => "text", 
                "label" => 'project::project.label.modified_at', 
                'sort' => true,
                'roles' => [],
            ],
            ")" => [
                "key" => ")", 
                "type" => "text", 
                "label" => 'project::project.label.)', 
                'sort' => true,
                'roles' => [],
            ],
            ")," => [
                "key" => "),", 
                "type" => "text", 
                "label" => 'project::project.label.),', 
                'sort' => true,
                'roles' => [],
            ],
            "id)," => [
                "key" => "id),", 
                "type" => "text", 
                "label" => 'project::project.label.id),', 
                'sort' => true,
                'roles' => [],
            ],
            "client_id)," => [
                "key" => "client_id),", 
                "type" => "text", 
                "label" => 'project::project.label.client_id),', 
                'sort' => true,
                'roles' => [],
            ],
            "project_manager_id)," => [
                "key" => "project_manager_id),", 
                "type" => "text", 
                "label" => 'project::project.label.project_manager_id),', 
                'sort' => true,
                'roles' => [],
            ],
        ],

        'form' => [
            'client_id' => [
                "element" => 'package::package.formcontrols.INT',
                "type" => 'package::package.formcontrols.INT',
                "label" => 'project::project.label.client_id',
                "placeholder" => 'project::project.placeholder.client_id',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'project_manager_id' => [
                "element" => 'package::package.formcontrols.INT',
                "type" => 'package::package.formcontrols.INT',
                "label" => 'project::project.label.project_manager_id',
                "placeholder" => 'project::project.placeholder.project_manager_id',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'status_id' => [
                "element" => 'package::package.formcontrols.VARCHAR',
                "type" => 'package::package.formcontrols.VARCHAR',
                "label" => 'project::project.label.status_id',
                "placeholder" => 'project::project.placeholder.status_id',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'name' => [
                "element" => 'package::package.formcontrols.VARCHAR',
                "type" => 'package::package.formcontrols.VARCHAR',
                "label" => 'project::project.label.name',
                "placeholder" => 'project::project.placeholder.name',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'path' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'project::project.label.path',
                "placeholder" => 'project::project.placeholder.path',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'language' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'project::project.label.language',
                "placeholder" => 'project::project.placeholder.language',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'domain' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'project::project.label.domain',
                "placeholder" => 'project::project.placeholder.domain',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'description' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'project::project.label.description',
                "placeholder" => 'project::project.placeholder.description',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'duration' => [
                "element" => 'text',
                "type" => 'text',
                "label" => 'project::project.label.duration',
                "placeholder" => 'project::project.placeholder.duration',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'deadline' => [
                "element" => 'package::package.formcontrols.VARCHAR',
                "type" => 'package::package.formcontrols.VARCHAR',
                "label" => 'project::project.label.deadline',
                "placeholder" => 'project::project.placeholder.deadline',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'modified_at' => [
                "element" => 'date_time_picker',
                "type" => 'date_time_picker',
                "label" => 'project::project.label.modified_at',
                "placeholder" => 'project::project.placeholder.modified_at',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            ')' => [
                "element" => 'package::package.formcontrols.ON',
                "type" => 'package::package.formcontrols.ON',
                "label" => 'project::project.label.)',
                "placeholder" => 'project::project.placeholder.)',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            '),' => [
                "element" => 'package::package.formcontrols.PRIMARY',
                "type" => 'package::package.formcontrols.PRIMARY',
                "label" => 'project::project.label.),',
                "placeholder" => 'project::project.placeholder.),',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'id),' => [
                "element" => 'package::package.formcontrols.INDEX',
                "type" => 'package::package.formcontrols.INDEX',
                "label" => 'project::project.label.id),',
                "placeholder" => 'project::project.placeholder.id),',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'client_id),' => [
                "element" => 'package::package.formcontrols.INDEX',
                "type" => 'package::package.formcontrols.INDEX',
                "label" => 'project::project.label.client_id),',
                "placeholder" => 'project::project.placeholder.client_id),',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            'project_manager_id),' => [
                "element" => 'package::package.formcontrols.INDEX',
                "type" => 'package::package.formcontrols.INDEX',
                "label" => 'project::project.label.project_manager_id),',
                "placeholder" => 'project::project.placeholder.project_manager_id),',
                "rules" => '',
                "group" => "main",
                "section" => "first",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
        ],

        'urls' => [
            'new' => [
                'url' => 'project/project/new',
                'method' => 'GET',
            ],
            'create' => [
                'url' => 'project/project/create',
                'method' => 'GET',
            ],
            'store' => [
                'url' => 'project/project',
                'method' => 'POST',
            ],
            'update' => [
                'url' => 'project/project',
                'method' => 'PUT',
            ],
            'list' => [
                'url' => 'project/project',
                'method' => 'GET',
            ],
            'delete' => [
                'url' => 'project/project',
                'method' => 'DELETE',
            ],
        ],
        'order' => [
            'created_at' => 'project::project.label.created_at',
            'name' => 'project::project.label.name',
            'status' => 'project::project.label.status',
        ],
        'groups' => [
            'main' => 'project::project.groups.main',
            'details' => 'project::project.groups.details',
            'images' => 'project::project.groups.images',
            'settings' => 'project::project.groups.settings',
        ],
        'controller' => [
            'provider' => 'Projects',
            'package' => 'Project',
            'module' => 'Project',
        ],
    ];
