<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;

class CreateProjectsTable extends Migration
{
    /*
     * Run the migrations.
     *
     * @return void
     */

    public function up()
    {

        /*
         * Table: projects
         */
        Schema::create('projects', function ($table) {
            $table->increments('id');
            $table->package::package.fieldtype.INT('client_id')->nullable();
            $table->package::package.fieldtype.INT('project_manager_id')->nullable();
            $table->package::package.fieldtype.VARCHAR('status_id')->nullable();
            $table->package::package.fieldtype.VARCHAR('name')->nullable();
            $table->string('path', 255)->nullable();
            $table->string('language', 255)->nullable();
            $table->string('domain', 255)->nullable();
            $table->text('description')->nullable();
            $table->string('duration', 255)->nullable();
            $table->package::package.fieldtype.VARCHAR('deadline')->nullable();
            $table->timestamp('modified_at')->nullable();
            $table->package::package.fieldtype.ON(')')->nullable();
            $table->package::package.fieldtype.PRIMARY('),')->nullable();
            $table->package::package.fieldtype.INDEX('id),')->nullable();
            $table->package::package.fieldtype.INDEX('client_id),')->nullable();
            $table->package::package.fieldtype.INDEX('project_manager_id),')->nullable();
            $table->softDeletes();
            $table->nullableTimestamps();
        });
    }

    /*
    * Reverse the migrations.
    *
    * @return void
    */

    public function down()
    {
        Schema::drop('projects');
    }
}
