<?php

namespace Projects\Project\Seeders;

use DB;
use Illuminate\Database\Seeder;

class ProjectTableSeeder extends Seeder
{
    public function run()
    {
        DB::table('projects')->insert([
            
        ]);

        DB::table('permissions')->insert([
            [
                'slug'      => 'project.project.view',
                'name'      => 'View Project',
            ],
            [
                'slug'      => 'project.project.create',
                'name'      => 'Create Project',
            ],
            [
                'slug'      => 'project.project.edit',
                'name'      => 'Update Project',
            ],
            [
                'slug'      => 'project.project.delete',
                'name'      => 'Delete Project',
            ],
            
            
        ]);

        DB::table('menus')->insert([
        
            // Admin menu
            [
                'parent_id'   => 1,
                'key'         => null,
                'url'         => 'admin/project/project',
                'name'        => 'Project',
                'description' => null,
                'icon'        => 'fa fa-newspaper-o',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],
            
            // User menu.
            [
                'parent_id'   => 2,
                'key'         => null,
                'url'         => 'user/project/project',
                'name'        => 'Project',
                'description' => null,
                'icon'        => 'icon-book-open',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

            // Public menu.
            [
                'parent_id'   => 3,
                'key'         => null,
                'url'         => 'project',
                'name'        => 'Project',
                'description' => null,
                'icon'        => null,
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

        ]);

        DB::table('settings')->insert([
            // Uncomment  and edit this section for entering value to settings table.
            /*
            [
                'pacakge'   => 'Project',
                'module'    => 'Project',
                'user_type' => null,
                'user_id'   => null,
                'key'       => 'project.project.key',
                'name'      => 'Some name',
                'value'     => 'Some value',
                'type'      => 'Default',
                'control'   => 'text',
            ],
            */
        ]);
    }
}
