# Installation

The instructions below will help you to properly install the generated package to the lavalite project.

## Location

Extract the package contents to the folder 

`/packages/projects/project/`

## Composer

Add the below entries in the `composer.json` file's autoload section and run the command `composer dump-autoload` in terminal.

```json

...
     "autoload": {

        "psr-4": {
            ... ,
            "Projects\\Project\\": "packages/projects/project/src",
            "Projects\\Project\\Seeders\\": "packages/projects/project/database/seeders"
            
            ...
        }
    },
...

```

## Config

Add the entries in service provider in `config/app.php`

```php

...
    'providers'       => [
        ...
        
        Projects\Project\Providers\ProjectServiceProvider::class,
        
        ...
    ],

    ...

    'alias'             => [
        ...
        
        'Project'  => Projects\Project\Facades\Project::class,
        
        ...
    ]
...

```

## Migrate

After service provider is set run the commapnd to migrate and seed the database.


    php artisan migrate
    php artisan db:seed --class=Projects\\Project\\Seeders\\ProjectTableSeeder

## Publishing


**Publishing configuration**

    php artisan vendor:publish --provider="Projects\Project\Providers\ProjectServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="Projects\Project\Providers\ProjectServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="Projects\Project\Providers\ProjectServiceProvider" --tag="view"


## URLs and APIs


### Web Urls

**Admin**

    http://path-to-route-folder/admin/project/{modulename}

**User**

    http://path-to-route-folder/user/project/{modulename}

**Public**

    http://path-to-route-folder/projects


### API endpoints

**List**
 
    http://path-to-route-folder/api/user/project/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/project/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/project/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/project/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/project/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/project/{modulename}/{slug}
    METHOD: GET