Lavalite package that provides project management facility for the cms.

## Installation

Begin by installing this package through Composer. Edit your project's `composer.json` file to require `projects/project`.

    "projects/project": "dev-master"

Next, update Composer from the Terminal:

    composer update

Once this operation completes execute below cammnds in command line to finalize installation.

    Projects\Project\Providers\ProjectServiceProvider::class,

And also add it to alias

    'Project'  => Projects\Project\Facades\Project::class,

## Publishing files and migraiting database.

**Migration and seeds**

    php artisan migrate
    php artisan db:seed --class=Projects\\Project\\Seeders\\ProjectTableSeeder

**Publishing configuration**

    php artisan vendor:publish --provider="Projects\Project\Providers\ProjectServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="Projects\Project\Providers\ProjectServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="Projects\Project\Providers\ProjectServiceProvider" --tag="view"


### Web Urls

**Admin**

    http://path-to-route-folder/admin/project/{modulename}

**User**

    http://path-to-route-folder/user/project/{modulename}

**Public**

    http://path-to-route-folder/projects


### API endpoints

**List**

    http://path-to-route-folder/api/user/project/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/project/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/project/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/project/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/project/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/project/{modulename}/{slug}
    METHOD: GET