<?php

namespace Projects\Project\Http\Resources;

use Illuminate\Http\Resources\Json\JsonResource;

class ProjectResource extends JsonResource
{

    public function itemLink()
    {
        return guard_url('project/project') . '/' . $this->getRouteKey();
    }

    public function title()
    {
        if ($this->title != '') {
            return $this->title;
        }

        if ($this->name != '') {
            return $this->name;
        }

        return 'None';
    }

    public function toArray($request)
    {
        return [
            'id' => $this->getRouteKey(),
            'title' => $this->title(),
            'client_id' => $this->client_id,
            'project_manager_id' => $this->project_manager_id,
            'status_id' => $this->status_id,
            'name' => $this->name,
            'path' => $this->path,
            'language' => $this->language,
            'domain' => $this->domain,
            'description' => $this->description,
            'duration' => $this->duration,
            'deadline' => $this->deadline,
            'modified_at' => $this->modified_at,
            ')' => $this->),
            '),' => $this->),,
            'id),' => $this->id),,
            'client_id),' => $this->client_id),,
            'project_manager_id),' => $this->project_manager_id),,
            'created_at' => !is_null($this->created_at) ? $this->created_at->format('Y-m-d H:i:s') : null,
            'updated_at' => !is_null($this->updated_at) ? $this->updated_at->format('Y-m-d H:i:s') : null,
            'meta' => [
                'exists' => $this->exists(),
                'link' => $this->itemLink(),
                'upload_url' => $this->getUploadURL(''),
            ],
        ];
    }
}
