<?php

namespace Projects\Project\Policies;

use Litepie\User\Interfaces\UserPolicyInterface;
use Projects\Project\Models\Project;

class ProjectPolicy
{

    /**
     * Determine if the given user can view the project.
     *
     * @param UserPolicyInterface $authUser
     * @param Project $project
     *
     * @return bool
     */
    public function view(UserPolicyInterface $authUser, Project $project)
    {
        if ($authUser->canDo('project.project.view') && $authUser->isAdmin()) {
            return true;
        }

        return $project->user_id == user_id() && $project->user_type == user_type();
    }

    /**
     * Determine if the given user can create a project.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function create(UserPolicyInterface $authUser)
    {
        return  $authUser->canDo('project.project.create');
    }

    /**
     * Determine if the given user can update the given project.
     *
     * @param UserPolicyInterface $authUser
     * @param Project $project
     *
     * @return bool
     */
    public function update(UserPolicyInterface $authUser, Project $project)
    {
        if ($authUser->canDo('project.project.edit') && $authUser->isAdmin()) {
            return true;
        }

        return $project->user_id == user_id() && $project->user_type == user_type();
    }

    /**
     * Determine if the given user can delete the given project.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function destroy(UserPolicyInterface $authUser, Project $project)
    {
        return $project->user_id == user_id() && $project->user_type == user_type();
    }

    /**
     * Determine if the given user can verify the given project.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function verify(UserPolicyInterface $authUser, Project $project)
    {
        if ($authUser->canDo('project.project.verify')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given project.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function approve(UserPolicyInterface $authUser, Project $project)
    {
        if ($authUser->canDo('project.project.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $authUser    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($authUser, $ability)
    {
        if ($authUser->isSuperuser()) {
            return true;
        }
    }
}
