<?php

namespace Projects\Project\Providers;

use Illuminate\Support\ServiceProvider;
use Projects\Project\Projects;

class ProjectServiceProvider extends ServiceProvider
{
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = true;

    /**
     * Bootstrap the application events.
     *
     * @return void
     */
    public function boot()
    {
        // Load view
        $this->loadViewsFrom(__DIR__ . '/../../resources/views', 'project');

        // Load translation
        $this->loadTranslationsFrom(__DIR__ . '/../../resources/lang', 'project');

        // Load migrations
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');

        // Call pblish redources function
        $this->publishResources();

    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        $this->mergeConfig();
        $this->registerFacade();
        // $this->registerCommands();

        $this->app->register(\Projects\Project\Providers\AuthServiceProvider::class);
        $this->app->register(\Projects\Project\Providers\RouteServiceProvider::class);
        // $this->app->register(\Projects\Project\Providers\EventServiceProvider::class);
        // $this->app->register(\Projects\Project\Providers\WorkflowServiceProvider::class);
    }

    /**
     * Register the vault facade without the user having to add it to the app.php file.
     *
     * @return void
     */
    public function registerFacade() {
        $this->app->bind('projects.project', function($app)
        {
            return $this->app->make(Projects::class);
        });
    }



    /**
     * Merges user's and project's configs.
     *
     * @return void
     */
    protected function mergeConfig()
    {
        $this->mergeConfigFrom(
            __DIR__ . '/../../config/config.php', 'projects.project'
        );
        
        
        $this->mergeConfigFrom(
            __DIR__ . '/../../config/project.php', 'projects.project.project'
        );
    }

    /**
     * Register scaffolding command
     */
    protected function registerCommands()
    {
        if ($this->app->runningInConsole()) {
            $this->commands([
                \Projects\Project\Commands\Project::class,
            ]);
        }
    }
    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return ['projects.project'];
    }

    /**
     * Publish resources.
     *
     * @return void
     */
    private function publishResources()
    {
        // Publish configuration file
        $this->publishes([__DIR__ . '/../../config/' => config_path('projects/project')], 'config');

        // Publish admin view
        $this->publishes([__DIR__ . '/../../resources/views' => base_path('resources/views/vendor/project')], 'view');

        // Publish language files
        $this->publishes([__DIR__ . '/../../resources/lang' => base_path('resources/lang/vendor/project')], 'lang');

        // Publish public files and assets.
        $this->publishes([__DIR__ . '/public/' => public_path('/')], 'public');
    }
}
