# Installation

The instructions below will help you to properly installand run the generated package to the lavalite project.

## Location

Extract the package contents to the folder 

`/packages/kimallen/00.0/`

## Composer

Add the below entries in the `composer.json`.


```json

...
     "repositories": {
        ...

        {
            "type": "path",
            "url": "packages/kimallen/00.0"
        }

        ...
    },
...

```
Then run `composer require kimallen/00.0`


## Migration and seeds

```
    php artisan migrate
    php artisan db:seed --class=Kimallen\\00.0\\Seeders\\00.0TableSeeder
```

## Publishing

* Configuration
```
    php artisan vendor:publish --provider="Kimallen\00.0\Providers\00.0ServiceProvider" --tag="config"
```
* Language
```
    php artisan vendor:publish --provider="Kimallen\00.0\Providers\00.0ServiceProvider" --tag="lang"
```
* Views
```
    php artisan vendor:publish --provider="Kimallen\00.0\Providers\00.0ServiceProvider" --tag="view"
```

## URLs and APIs

### Web Urls

* Admin
```
    http://path-to-route-folder/admin/00.0/{modulename}
```

* User
```
    http://path-to-route-folder/user/00.0/{modulename}
```

* Public
```
    http://path-to-route-folder/00.0s
```


### API endpoints

These endpoints can be used with or without `/api/`
And also the user can be varied depend on the type of users, eg user, client, admin etc.

#### Resource

* List
```
    http://path-to-route-folder/api/user/00.0/{modulename}
    METHOD: GET
```

* Create
```
    http://path-to-route-folder/api/user/00.0/{modulename}
    METHOD: POST
```

* Edit
```
    http://path-to-route-folder/api/user/00.0/{modulename}/{id}
    METHOD: PUT
```

* Delete
```
    http://path-to-route-folder/api/user/00.0/{modulename}/{id}
    METHOD: DELETE
```

#### Public

* List
```
    http://path-to-route-folder/api/00.0/{modulename}
    METHOD: GET
```

* Single Item
```
    http://path-to-route-folder/api/00.0/{modulename}/{slug}
    METHOD: GET
```

#### Others

* Report
```
    http://path-to-route-folder/api/user/00.0/{modulename}/report/{report}
    METHOD: GET
```

* Export/Import
```
    http://path-to-route-folder/api/user/00.0/{modulename}/exim/{exim}
    METHOD: POST
```

* Action
```
    http://path-to-route-folder/api/user/00.0/{modulename}/action/{id}/{action}
    METHOD: PATCH
```

* Actions
```
    http://path-to-route-folder/api/user/00.0/{modulename}/actions/{action}
    METHOD: PATCH
```

* Workflow
```
    http://path-to-route-folder/api/user/00.0/{modulename}/workflow/{id}/{transition}
    METHOD: PATCH
```
