<?php

namespace Litecms\RestaurantApp\Seeders;

use DB;
use Illuminate\Database\Seeder;

class RestaurantAppTableSeeder extends Seeder
{
    public function run()
    {
        DB::table('restaurant_apps')->insert([
            
        ]);

        DB::table('permissions')->insert([
            [
                'slug'      => 'restaurant_app.restaurant_app.view',
                'name'      => 'View RestaurantApp',
            ],
            [
                'slug'      => 'restaurant_app.restaurant_app.create',
                'name'      => 'Create RestaurantApp',
            ],
            [
                'slug'      => 'restaurant_app.restaurant_app.edit',
                'name'      => 'Update RestaurantApp',
            ],
            [
                'slug'      => 'restaurant_app.restaurant_app.delete',
                'name'      => 'Delete RestaurantApp',
            ],
            
            
        ]);

        DB::table('menus')->insert([
        
            // Admin menu
            [
                'parent_id'   => 1,
                'key'         => null,
                'url'         => 'admin/restaurant_app/restaurant_app',
                'name'        => 'RestaurantApp',
                'description' => null,
                'icon'        => 'fa fa-newspaper-o',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],
            
            // User menu.
            [
                'parent_id'   => 2,
                'key'         => null,
                'url'         => 'user/restaurant_app/restaurant_app',
                'name'        => 'RestaurantApp',
                'description' => null,
                'icon'        => 'icon-book-open',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

            // Public menu.
            [
                'parent_id'   => 3,
                'key'         => null,
                'url'         => 'restaurant_app',
                'name'        => 'RestaurantApp',
                'description' => null,
                'icon'        => null,
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

        ]);

        DB::table('settings')->insert([
            // Uncomment  and edit this section for entering value to settings table.
            /*
            [
                'pacakge'   => 'RestaurantApp',
                'module'    => 'RestaurantApp',
                'user_type' => null,
                'user_id'   => null,
                'key'       => 'restaurant_app.restaurant_app.key',
                'name'      => 'Some name',
                'value'     => 'Some value',
                'type'      => 'Default',
                'control'   => 'text',
            ],
            */
        ]);
    }
}
