# Installation

The instructions below will help you to properly install the generated package to the lavalite project.

## Location

Extract the package contents to the folder 

`/packages/litecms/restaurant_app/`

## Composer

Add the below entries in the `composer.json` file's autoload section and run the command `composer dump-autoload` in terminal.

```json

...
     "autoload": {

        "psr-4": {
            ... ,
            "Litecms\\RestaurantApp\\": "packages/litecms/restaurant_app/src",
            "Litecms\\RestaurantApp\\Seeders\\": "packages/litecms/restaurant_app/database/seeders"
            
            ...
        }
    },
...

```

## Config

Add the entries in service provider in `config/app.php`

```php

...
    'providers'       => [
        ...
        
        Litecms\RestaurantApp\Providers\RestaurantAppServiceProvider::class,
        
        ...
    ],

    ...

    'alias'             => [
        ...
        
        'RestaurantApp'  => Litecms\RestaurantApp\Facades\RestaurantApp::class,
        
        ...
    ]
...

```

## Migrate

After service provider is set run the commapnd to migrate and seed the database.


    php artisan migrate
    php artisan db:seed --class=Litecms\\RestaurantApp\\Seeders\\RestaurantAppTableSeeder

## Publishing


**Publishing configuration**

    php artisan vendor:publish --provider="Litecms\RestaurantApp\Providers\RestaurantAppServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="Litecms\RestaurantApp\Providers\RestaurantAppServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="Litecms\RestaurantApp\Providers\RestaurantAppServiceProvider" --tag="view"


## URLs and APIs


### Web Urls

**Admin**

    http://path-to-route-folder/admin/restaurant_app/{modulename}

**User**

    http://path-to-route-folder/user/restaurant_app/{modulename}

**Public**

    http://path-to-route-folder/restaurant_apps


### API endpoints

**List**
 
    http://path-to-route-folder/api/user/restaurant_app/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/restaurant_app/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/restaurant_app/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/restaurant_app/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/restaurant_app/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/restaurant_app/{modulename}/{slug}
    METHOD: GET