Lavalite package that provides restaurant_app management facility for the cms.

## Installation

Begin by installing this package through Composer. Edit your project's `composer.json` file to require `litecms/restaurant_app`.

    "litecms/restaurant_app": "dev-master"

Next, update Composer from the Terminal:

    composer update

Once this operation completes execute below cammnds in command line to finalize installation.

    Litecms\RestaurantApp\Providers\RestaurantAppServiceProvider::class,

And also add it to alias

    'RestaurantApp'  => Litecms\RestaurantApp\Facades\RestaurantApp::class,

## Publishing files and migraiting database.

**Migration and seeds**

    php artisan migrate
    php artisan db:seed --class=Litecms\\RestaurantApp\\Seeders\\RestaurantAppTableSeeder

**Publishing configuration**

    php artisan vendor:publish --provider="Litecms\RestaurantApp\Providers\RestaurantAppServiceProvider" --tag="config"

**Publishing language**

    php artisan vendor:publish --provider="Litecms\RestaurantApp\Providers\RestaurantAppServiceProvider" --tag="lang"

**Publishing views**

    php artisan vendor:publish --provider="Litecms\RestaurantApp\Providers\RestaurantAppServiceProvider" --tag="view"


### Web Urls

**Admin**

    http://path-to-route-folder/admin/restaurant_app/{modulename}

**User**

    http://path-to-route-folder/user/restaurant_app/{modulename}

**Public**

    http://path-to-route-folder/restaurant_apps


### API endpoints

**List**

    http://path-to-route-folder/api/user/restaurant_app/{modulename}
    METHOD: GET

**Create**

    http://path-to-route-folder/api/user/restaurant_app/{modulename}
    METHOD: POST

**Edit**

    http://path-to-route-folder/api/user/restaurant_app/{modulename}/{id}
    METHOD: PUT

**Delete**

    http://path-to-route-folder/api/user/restaurant_app/{modulename}/{id}
    METHOD: DELETE

**Public List**

    http://path-to-route-folder/api/restaurant_app/{modulename}
    METHOD: GET

**Public Single**

    http://path-to-route-folder/api/restaurant_app/{modulename}/{slug}
    METHOD: GET