@include('restaurant_app::public.restaurant_app.partial.header')
<section class="listing-page-wrap">
    <div class="container">
        <div class="row">
            @include('restaurant_app::public.restaurant_app.partial.aside')

            <div class="col-12 col-lg-9 left-sidebar" id="listing_data">
                @forelse($data as $restaurant_app)
                @php 
                $restaurant_app = $restaurant_app->toArray([]);
                @endphp
                <div class="listing-single-item d-flex align-items-center flex-wrap">
                    <div class="col-12 col-lg-5 p-0 listing-image">
                        <a href="{{trans_url('restaurant_app')}}/{{$restaurant_app['slug']}}">
                        <img src="{{url($restaurant_app['image'])}}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col-12 col-lg-6 p-0 listing-text">
                        <div class="listing-content">
                            <h3><a href="{{trans_url('restaurant_app')}}/{{$restaurant_app['slug']}}">{{$restaurant_app['title']}}</a></h3>
                            <div class="listing-metas">
                                <span>By <a
                                        href="{{trans_url('restaurant_app')}}/{{$restaurant_app['slug']}}">{{$restaurant_app['user']}}</a></span>
                                <span><a
                                        href="{{trans_url('restaurant_app')}}/{{$restaurant_app['slug']}}">{{$restaurant_app['category']}}</a></span>
                            </div>
                            <p>{{ Str::limit($restaurant_app['description'],300 )}}</p>
                        </div>
                        <a href="{{trans_url('restaurant_app')}}/{{$restaurant_app['slug']}}" class="btn btn-theme">Continue Reading</a>
                    </div>
                </div>
                @empty
                @endif
                <nav class="pagination-wrap mb-50" aria-label="Page navigation example">
                    <ul class="pagination">
                        {!!view('paginator', compact('meta'))!!}
                    </ul>
                </nav>
            </div>
        </div>
    </div>
</section>
