<?php

namespace Litecms\RestaurantApp\Http\Controllers;

use App\Http\Controllers\PublicController as BaseController;
use App\Http\Requests\PublicRequest;
use Litepie\Database\RequestScope;
use Litecms\RestaurantApp\Http\Resources\RestaurantAppResource;
use Litecms\RestaurantApp\Http\Resources\RestaurantAppsCollection;
use Litecms\RestaurantApp\Scopes\RestaurantAppPublicScope;
use Litecms\RestaurantApp\Models\RestaurantApp;

class RestaurantAppPublicController extends BaseController
{

    /**
     * Show restaurant_app's list.
     *
     * @return response
     */
    protected function index(PublicRequest $request)
    {

        $search = $request->search;
        $pageLimit = $request->input('pageLimit', config('database.pagination.limit'));
        $page = RestaurantApp::pushScope(new RequestScope())
            ->pushScope(new RestaurantAppPublicScope())
            ->select('restaurant_apps.*')
            ->paginate($pageLimit)
            ->withQueryString();

        $data = new RestaurantAppsCollection($page);

        $categories = [];
        $tags = [];
        $recent = [];

        return $this->response->setMetaTitle(trans('restaurant_app::restaurant_app.names'))
            ->view('restaurant_app::public.restaurant_app.index')
            ->data(compact('data', 'categories', 'tags', 'recent'))
            ->output();
    }

    /**
     * Show restaurant_app.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function show(PublicRequest $request, $slug)
    {
        $model = RestaurantApp::findBySlug($slug);
        $data = new RestaurantAppResource($model);

        $categories = [];
        $tags = [];
        $recent = [];
    
        return $this->response->setMetaTitle($data['title'] . trans('restaurant_app::restaurant_app.name'))
            ->view('restaurant_app::public.restaurant_app.show')
            ->data(compact('data', 'categories', 'tags', 'recent'))
            ->output();
    }

}
