<?php

namespace Litecms\RestaurantApp\Policies;

use Litepie\User\Interfaces\UserPolicyInterface;
use Litecms\RestaurantApp\Models\RestaurantApp;

class RestaurantAppPolicy
{

    /**
     * Determine if the given user can view the restaurant_app.
     *
     * @param UserPolicyInterface $authUser
     * @param RestaurantApp $restaurant_app
     *
     * @return bool
     */
    public function view(UserPolicyInterface $authUser, RestaurantApp $restaurant_app)
    {
        if ($authUser->canDo('restaurant_app.restaurant_app.view') && $authUser->isAdmin()) {
            return true;
        }

        return $restaurant_app->user_id == user_id() && $restaurant_app->user_type == user_type();
    }

    /**
     * Determine if the given user can create a restaurant_app.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function create(UserPolicyInterface $authUser)
    {
        return  $authUser->canDo('restaurant_app.restaurant_app.create');
    }

    /**
     * Determine if the given user can update the given restaurant_app.
     *
     * @param UserPolicyInterface $authUser
     * @param RestaurantApp $restaurant_app
     *
     * @return bool
     */
    public function update(UserPolicyInterface $authUser, RestaurantApp $restaurant_app)
    {
        if ($authUser->canDo('restaurant_app.restaurant_app.edit') && $authUser->isAdmin()) {
            return true;
        }

        return $restaurant_app->user_id == user_id() && $restaurant_app->user_type == user_type();
    }

    /**
     * Determine if the given user can delete the given restaurant_app.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function destroy(UserPolicyInterface $authUser, RestaurantApp $restaurant_app)
    {
        return $restaurant_app->user_id == user_id() && $restaurant_app->user_type == user_type();
    }

    /**
     * Determine if the given user can verify the given restaurant_app.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function verify(UserPolicyInterface $authUser, RestaurantApp $restaurant_app)
    {
        if ($authUser->canDo('restaurant_app.restaurant_app.verify')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given restaurant_app.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function approve(UserPolicyInterface $authUser, RestaurantApp $restaurant_app)
    {
        if ($authUser->canDo('restaurant_app.restaurant_app.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $authUser    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($authUser, $ability)
    {
        if ($authUser->isSuperuser()) {
            return true;
        }
    }
}
