<?php

namespace Litecms\RestaurantApp\Providers;

use Illuminate\Support\ServiceProvider;
use Litecms\RestaurantApp\RestaurantApps;

class RestaurantAppServiceProvider extends ServiceProvider
{
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = true;

    /**
     * Bootstrap the application events.
     *
     * @return void
     */
    public function boot()
    {
        // Load view
        $this->loadViewsFrom(__DIR__ . '/../../resources/views', 'restaurant_app');

        // Load translation
        $this->loadTranslationsFrom(__DIR__ . '/../../resources/lang', 'restaurant_app');

        // Load migrations
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');

        // Call pblish redources function
        $this->publishResources();

    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        $this->mergeConfig();
        $this->registerFacade();
        // $this->registerCommands();

        $this->app->register(\Litecms\RestaurantApp\Providers\AuthServiceProvider::class);
        $this->app->register(\Litecms\RestaurantApp\Providers\RouteServiceProvider::class);
        // $this->app->register(\Litecms\RestaurantApp\Providers\EventServiceProvider::class);
        // $this->app->register(\Litecms\RestaurantApp\Providers\WorkflowServiceProvider::class);
    }

    /**
     * Register the vault facade without the user having to add it to the app.php file.
     *
     * @return void
     */
    public function registerFacade() {
        $this->app->bind('litecms.restaurant_app', function($app)
        {
            return $this->app->make(RestaurantApps::class);
        });
    }



    /**
     * Merges user's and restaurant_app's configs.
     *
     * @return void
     */
    protected function mergeConfig()
    {
        $this->mergeConfigFrom(
            __DIR__ . '/../../config/config.php', 'litecms.restaurant_app'
        );
        
        
        $this->mergeConfigFrom(
            __DIR__ . '/../../config/restaurant_app.php', 'litecms.restaurant_app.restaurant_app'
        );
    }

    /**
     * Register scaffolding command
     */
    protected function registerCommands()
    {
        if ($this->app->runningInConsole()) {
            $this->commands([
                \Litecms\RestaurantApp\Commands\RestaurantApp::class,
            ]);
        }
    }
    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return ['litecms.restaurant_app'];
    }

    /**
     * Publish resources.
     *
     * @return void
     */
    private function publishResources()
    {
        // Publish configuration file
        $this->publishes([__DIR__ . '/../../config/' => config_path('litecms/restaurant_app')], 'config');

        // Publish admin view
        $this->publishes([__DIR__ . '/../../resources/views' => base_path('resources/views/vendor/restaurant_app')], 'view');

        // Publish language files
        $this->publishes([__DIR__ . '/../../resources/lang' => base_path('resources/lang/vendor/restaurant_app')], 'lang');

        // Publish public files and assets.
        $this->publishes([__DIR__ . '/public/' => public_path('/')], 'public');
    }
}
