# Installation

The instructions below will help you to properly installand run the generated package to the lavalite project.

## Location

Extract the package contents to the folder 

`/packages/provider/select2/`

## Composer

Add the below entries in the `composer.json`.


```json

...
     "repositories": {
        ...

        {
            "type": "path",
            "url": "packages/provider/select2"
        }

        ...
    },
...

```
Then run `composer require provider/select2`


## Migration and seeds

```
    php artisan migrate
    php artisan db:seed --class=Provider\\Select2\\Seeders\\Select2TableSeeder
```

## Publishing

* Configuration
```
    php artisan vendor:publish --provider="Provider\Select2\Providers\Select2ServiceProvider" --tag="config"
```
* Language
```
    php artisan vendor:publish --provider="Provider\Select2\Providers\Select2ServiceProvider" --tag="lang"
```
* Views
```
    php artisan vendor:publish --provider="Provider\Select2\Providers\Select2ServiceProvider" --tag="view"
```

## URLs and APIs

### Web Urls

* Admin
```
    http://path-to-route-folder/admin/select2/{modulename}
```

* User
```
    http://path-to-route-folder/user/select2/{modulename}
```

* Public
```
    http://path-to-route-folder/select2s
```


### API endpoints

These endpoints can be used with or without `/api/`
And also the user can be varied depend on the type of users, eg user, client, admin etc.

#### Resource

* List
```
    http://path-to-route-folder/api/user/select2/{modulename}
    METHOD: GET
```

* Create
```
    http://path-to-route-folder/api/user/select2/{modulename}
    METHOD: POST
```

* Edit
```
    http://path-to-route-folder/api/user/select2/{modulename}/{id}
    METHOD: PUT
```

* Delete
```
    http://path-to-route-folder/api/user/select2/{modulename}/{id}
    METHOD: DELETE
```

#### Public

* List
```
    http://path-to-route-folder/api/select2/{modulename}
    METHOD: GET
```

* Single Item
```
    http://path-to-route-folder/api/select2/{modulename}/{slug}
    METHOD: GET
```

#### Others

* Report
```
    http://path-to-route-folder/api/user/select2/{modulename}/report/{report}
    METHOD: GET
```

* Export/Import
```
    http://path-to-route-folder/api/user/select2/{modulename}/exim/{exim}
    METHOD: POST
```

* Action
```
    http://path-to-route-folder/api/user/select2/{modulename}/action/{id}/{action}
    METHOD: PATCH
```

* Actions
```
    http://path-to-route-folder/api/user/select2/{modulename}/actions/{action}
    METHOD: PATCH
```

* Workflow
```
    http://path-to-route-folder/api/user/select2/{modulename}/workflow/{id}/{transition}
    METHOD: PATCH
```
