<?php


return  
    [
        'model' => [
            'model' => \Bixo\Source\Models\Source::class,
            'table' => 'bixo_source_sources',
            'hidden'=> [],
            'visible' => [],
            'guarded' => ['*'],
            'slugs' => ['slug' => 'name'],
            'dates' => ['deleted_at', 'created_at', 'updated_at'],
            'appends' => [],
            'fillable' => ['name',  'type',  'user_id',  'user_type'],
            'translatables' => [],
            'upload_folder' => 'source/source',
            'uploads' => [
            /*
                    'images' => [
                        'count' => 10,
                        'type'  => 'image',
                    ],
                    'file' => [
                        'count' => 1,
                        'type'  => 'file',
                    ],
            */
            ],

            'casts' => [
            
            /*
                'images'    => 'array',
                'file'      => 'array',
            */
            ],

            'revision' => [],
            'perPage' => '20',
            'search'        => [
                'name'  => 'like',
                'status',
            ]
        ],

        'search' => [
            
        ],

        'list' => [
            [
                "key" => "name", 
                "type" => "text", 
                "label" => 'source::source.label.name', 
                'sort' => true,
                'roles' => [],
            ],
            [
                "key" => "type", 
                "type" => "text", 
                "label" => 'source::source.label.type', 
                'sort' => true,
                'roles' => [],
            ],
        ],

        'form' => [
            [
                "key" => 'name',
                "element" => 'text',
                "type" => 'text',
                "label" => 'source::source.label.name',
                "placeholder" => 'source::source.placeholder.name',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
            [
                "key" => 'type',
                "element" => 'text',
                "type" => 'text',
                "label" => 'source::source.label.type',
                "placeholder" => 'source::source.placeholder.type',
                "rules" => '',
                "group" => "main.main",
                "col" => "6",
                "append" => null,
                "prepend" => null,
                "roles" => [],
                "attributes" => [
                    'wrapper' => [],
                    "label" => [],
                    "element" => [],

                ],
            ],
        ],

        'urls' => [
            'new' => [
                'url' => 'source/source/new',
                'method' => 'GET',
            ],
            'create' => [
                'url' => 'source/source/create',
                'method' => 'GET',
            ],
            'store' => [
                'url' => 'source/source',
                'method' => 'POST',
            ],
            'update' => [
                'url' => 'source/source',
                'method' => 'PUT',
            ],
            'list' => [
                'url' => 'source/source',
                'method' => 'GET',
            ],
            'delete' => [
                'url' => 'source/source',
                'method' => 'DELETE',
            ],
        ],

        'order' => [
            'created_at' => 'source::source.label.created_at',
            'name' => 'source::source.label.name',
            'status' => 'source::source.label.status',
        ],

        'groups' => [
            [
                'icon' => "mdi:account-supervisor-outline",
                'name' => "source::source.groups.main",
                'group' => "main.main",
                'title' => "source::source.groups.main",
            ],
            [
                'icon' => "fe:home",
                'name' => "source::source.groups.details",
                'group' => "main.details",
                'title' => "source::source.groups.details",
            ],
            'images' => [
                'icon' => "fe:home",
                'name' => "source::source.groups.images",
                'group' => "main.images",
                'title' => "source::source.groups.images",
            ],
            'settings' => [
                'icon' => "fe:home",
                'name' => "source::source.groups.settings",
                'group' => "main.settings",
                'title' => "source::source.groups.settings",
            ]
        ],

        'controller' => [
            'provider' => 'Bixo',
            'package' => 'Source',
            'module' => 'Source',
        ],

        
         
        'actions' => [
            'copy' => [
                'type' => ['Details', 'List'],
                'label' => 'source::source.action.copy',
                'roles' => [
                    'user' => ['superuser', 'admin'],
                    'team' => ['admin'],
                    'permission' => ['source.source.copy', 'source.source.duplicate'],
                ],
                'form' => [
                    'count' => [
                        "element" => 'select',
                        "type" => 'select',
                        "label" => 'source::source.label.count',
                        "placeholder" => 'source::source.placeholder.count',
                        "options" => call_user_func(function () {
                            return [
                                1 => ['value' => 1, 'text' => 1],
                                2 => ['value' => 2, 'text' => 2],
                                3 => ['value' => 3, 'text' => 3],
                                4 => ['value' => 4, 'text' => 4],
                            ];
                        }),
                        "col" => "12",
                    ],
                    'comment' => [
                        "element" => 'textarea',
                        "type" => 'text',
                        "required" => 'required',
                        "label" => 'source::source.label.comment',
                        "placeholder" => 'source::source.placeholder.comment',
                        "col" => "12",
                    ],
                ],
            ],
            'empty' => [
                'type' => ['List', 'Details'],
                'label' => 'source::source.action.empty',
                'roles' => [
                    'user' => ['superuser'],
                ],
            ],
            
            'section' => [
                'type' => ['Group'],
                'api_url' => '',
                'action' => 'list',
                'label' => 'source::source.action.section',
                'store' => 'main.units',
                'group' => 'main.units'
            ],

        ]
        
    ];
