<?php

namespace Bixo\Source\Seeders;

use Illuminate\Support\Facades\DB;
use Illuminate\Database\Seeder;

class SourceTableSeeder extends Seeder
{
    public function run()
    {
        DB::table('bixo_source_sources')->insert([
            
        ]);

        DB::table('permissions')->insert([
            [
                'slug'      => 'bixo.source.source.view',
                'name'      => 'View Source',
            ],
            [
                'slug'      => 'bixo.source.source.create',
                'name'      => 'Create Source',
            ],
            [
                'slug'      => 'bixo.source.source.edit',
                'name'      => 'Update Source',
            ],
            [
                'slug'      => 'bixo.source.source.delete',
                'name'      => 'Delete Source',
            ],
            
            
                    ]);

        DB::table('menus')->insert([
        
            // Admin menu
            [
                'parent_id'   => 1,
                'key'         => null,
                'url'         => 'admin/source/source',
                'name'        => 'Source',
                'description' => null,
                'icon'        => 'las la-scroll',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],
            
            // User menu.
            [
                'parent_id'   => 2,
                'key'         => null,
                'url'         => 'user/source/source',
                'name'        => 'Source',
                'description' => null,
                'icon'        => 'las la-scroll',
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

            // Public menu.
            [
                'parent_id'   => 3,
                'key'         => null,
                'url'         => 'source',
                'name'        => 'Source',
                'description' => null,
                'icon'        => 'las la-scroll,
                'target'      => null,
                'order'       => 190,
                'status'      => 1,
            ],

        ]);

        DB::table('settings')->insert([
            // Uncomment  and edit this section for entering value to settings table.
            /*
            [
                'pacakge'   => 'Source',
                'module'    => 'Source',
                'user_type' => null,
                'user_id'   => null,
                'key'       => 'bixo.source.source.key',
                'name'      => 'Some name',
                'value'     => 'Some value',
                'type'      => 'Default',
                'control'   => 'text',
            ],
            */
        ]);
    }
}
