# Installation

The instructions below will help you to properly installand run the generated package to the lavalite project.

## Location

Extract the package contents to the folder 

`/packages/bixo/source/`

## Composer

Add the below entries in the `composer.json`.


```json

...
     "repositories": {
        ...

        {
            "type": "path",
            "url": "packages/bixo/source"
        }

        ...
    },
...

```
Then run `composer require bixo/source`


## Migration and seeds

```
    php artisan migrate
    php artisan db:seed --class=Bixo\\Source\\Seeders\\SourceTableSeeder
```

## Publishing

* Configuration
```
    php artisan vendor:publish --provider="Bixo\Source\Providers\SourceServiceProvider" --tag="config"
```
* Language
```
    php artisan vendor:publish --provider="Bixo\Source\Providers\SourceServiceProvider" --tag="lang"
```
* Views
```
    php artisan vendor:publish --provider="Bixo\Source\Providers\SourceServiceProvider" --tag="view"
```

## URLs and APIs

### Web Urls

* Admin
```
    http://path-to-route-folder/admin/source/{modulename}
```

* User
```
    http://path-to-route-folder/user/source/{modulename}
```

* Public
```
    http://path-to-route-folder/sources
```


### API endpoints

These endpoints can be used with or without `/api/`
And also the user can be varied depend on the type of users, eg user, client, admin etc.

#### Resource

* List
```
    http://path-to-route-folder/api/user/source/{modulename}
    METHOD: GET
```

* Create
```
    http://path-to-route-folder/api/user/source/{modulename}
    METHOD: POST
```

* Edit
```
    http://path-to-route-folder/api/user/source/{modulename}/{id}
    METHOD: PUT
```

* Delete
```
    http://path-to-route-folder/api/user/source/{modulename}/{id}
    METHOD: DELETE
```

#### Public

* List
```
    http://path-to-route-folder/api/source/{modulename}
    METHOD: GET
```

* Single Item
```
    http://path-to-route-folder/api/source/{modulename}/{slug}
    METHOD: GET
```

#### Others

* Report
```
    http://path-to-route-folder/api/user/source/{modulename}/report/{report}
    METHOD: GET
```

* Export/Import
```
    http://path-to-route-folder/api/user/source/{modulename}/exim/{exim}
    METHOD: POST
```

* Action
```
    http://path-to-route-folder/api/user/source/{modulename}/action/{id}/{action}
    METHOD: PATCH
```

* Actions
```
    http://path-to-route-folder/api/user/source/{modulename}/actions/{action}
    METHOD: PATCH
```

* Workflow
```
    http://path-to-route-folder/api/user/source/{modulename}/workflow/{id}/{transition}
    METHOD: PATCH
```
