@include('source::public.source.partial.header')
<section class="listing-page-wrap">
    <div class="container">
        <div class="row">
            @include('source::public.source.partial.aside')

            <div class="col-12 col-lg-9 left-sidebar" id="listing_data">
                @forelse($sources as $source)
                @php 
                $source = $source->toArray([]);
                @endphp
                <div class="listing-single-item d-flex align-items-center flex-wrap">
                    <div class="col-12 col-lg-5 p-0 listing-image">
                        <a href="{{trans_url('source')}}/{{$source['slug']}}">
                        <img src="{{url($source['image']['main'])}}" class="img-fluid" alt="">
                        </a>
                    </div>
                    <div class="col-12 col-lg-6 p-0 listing-text">
                        <div class="listing-content">
                            <h3><a href="{{trans_url('source')}}/{{$source['slug']}}">{{$source['title']}}</a></h3>
                            <div class="listing-metas">
                                <span>By <a
                                        href="{{trans_url('source')}}/{{$source['slug']}}">User</a></span>
                                <span><a
                                        href="{{trans_url('source')}}/{{$source['slug']}}">Category</a></span>
                            </div>
                            <p>{{ Str::limit($source['description'], 300 )}}</p>
                        </div>
                        <a href="{{trans_url('source')}}/{{$source['slug']}}" class="btn btn-theme">Continue Reading</a>
                    </div>
                </div>
                <nav class="pagination-wrap mb-50" aria-label="Page navigation example">
                    <ul class="pagination">
                        @php 
                        $meta = $source['meta'];
                        @endphp
                        {!!view('paginator', compact('meta'))!!}
                    </ul>
                </nav>
                @empty
                @endif
            </div>
        </div>
    </div>
</section>
