<?php

namespace Bixo\Source\Actions;

use Illuminate\Support\Carbon;
use Illuminate\Support\Str;
use Litepie\Actions\Concerns\AsAction;
use Bixo\Source\Models\Source;


class SourceAction
{
    use AsAction;

    protected $model;
    protected $namespace = 'bixo.source.source';
    protected $eventClass = \Bixo\Source\Events\SourceAction::class;
    protected $action;
    protected $function;
    protected $request;

    public function handle(string $action, Source $source, array $request = [])
    {
        $this->action = $action;
        $this->request = $request;
        $this->model = $source;
        $this->function = Str::camel($action);
        $this->executeAction();
        return $this->model;

    }


    public function store(Source $source, array $request)
    {
        $attributes = $request;
        $attributes['user_id'] = user_id();
        $attributes['user_type'] = user_type();
        $source = $source->create($attributes);
        return $source;
    }

    public function update(Source $source, array $request)
    {
        $attributes = $request;
        $source->update($attributes);
        return $source;
    }

    public function destroy(Source $source, array $request)
    {
        $source->delete();
        return $source;
    }

    public function copy(Source $source, array $request)
    {
        $count = $request['count'] ?: 1;

        if ($count == 1) {
            $source = $source->replicate();
            $source->created_at = Carbon::now();
            $source->save();
            return $source;
        }

        for ($i = 1; $i <= $count; $i++) {
            $new = $source->replicate();
            $new->created_at = Carbon::now();
            $new->save();
        }

        return $source;
    }


}
