<?php

namespace Bixo\Source\Events;

use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Foundation\Events\Dispatchable;
use Illuminate\Queue\SerializesModels;
use Bixo\Source\Models\Source;

class SourceAction
{
    use Dispatchable, InteractsWithSockets, SerializesModels;

    /**
     * Create a new event instance.
     */
    public function __construct(
        public string $action,
        public Source $source,
        public array $request = [],
        public string $when = 'after'
    ) {}
}
