<?php

namespace Bixo\Source\Http\Controllers;

use App\Http\Controllers\ActionController as BaseController;
use Exception;
use Bixo\Source\Actions\SourceAction;
use Bixo\Source\Http\Requests\SourceActionRequest;
use Bixo\Source\Http\Resources\SourceResource;
use Bixo\Source\Models\Source;

/**
 * Admin web controller class.
 */
class SourceActionController extends BaseController
{

    /**
     * Action controller function for source.
     *
     * @param Model $model
     * @param action next action for the model.
     *
     * @return Response
     */
    public function __invoke(SourceActionRequest $request, Source $source, $action)
    {
        try {
            $request = $request->all();
            $source = SourceAction::run($action, $source, $request);

            $data = new SourceResource($source);
            return $this->response->message(trans("messages.success.{$action}", ['Module' => trans('source::source.name')]))
                ->code(204)
                ->data(compact('data'))
                ->status('success')
                ->url(guard_url('source/source/' . $source->getRouteKey()))
                ->redirect();
        } catch (Exception $e) {
            return $this->response->message($e->getMessage())
                ->code(400)
                ->status('error')
                ->url(guard_url('source/source/' . $source->getRouteKey()))
                ->redirect();
        }
    }

    public function notify(){
        
    }
}
