<?php

namespace Bixo\Source\Http\Controllers;

use App\Http\Controllers\Controller as BaseController;
use Exception;
use Bixo\Source\Http\Requests\SourceActionsRequest;
use Bixo\Source\Actions\SourceActions;

/**
 * Admin web controller class.
 */
class SourceActionsController extends BaseController
{

    /**
     * Action controller function for source.
     *
     * @param Model $model
     * @param action next action for the model.
     *
     * @return Response
     */
    public function __invoke(SourceActionsRequest $request, $action)
    {
        try {
            $source = SourceActions::run($request, $action);
            return $this->response->message(trans('messages.success.updated', ['Module' => trans('source::source.name')]))
                ->code(204)
                ->data(compact('data'))
                ->status('success')
                ->url(guard_url('source/source/' . $action))
                ->redirect();
        } catch (Exception $e) {
            return $this->response->message($e->getMessage())
                ->code(400)
                ->status('error')
                ->url(guard_url('source/source/' . $action))
                ->redirect();
        }
    }
}
