<?php

namespace Bixo\Source\Http\Controllers;

use App\Http\Controllers\PublicController as BaseController;
use App\Http\Requests\PublicRequest;
use Litepie\Database\RequestScope;
use Bixo\Source\Http\Resources\SourceResource;
use Bixo\Source\Http\Resources\SourcesCollection;
use Bixo\Source\Scopes\SourcePublicScope;
use Bixo\Source\Models\Source;

class SourcePublicController extends BaseController
{

    /**
     * Show source's list.
     *
     * @return response
     */
    protected function index(PublicRequest $request)
    {

        $search = $request->search;
        $pageLimit = $request->input('pageLimit', config('database.pagination.limit'));
        $page = Source::pushScope(new RequestScope())
            ->pushScope(new SourcePublicScope())
            ->paginate($pageLimit)
            ->withQueryString();

        $sources = new SourcesCollection($page);

        $categories = [];
        $tags = [];
        $recent = [];

        return $this->response->setMetaTitle(trans('source::source.names'))
            ->view('source::public.source.index')
            ->data(compact('sources', 'categories', 'tags', 'recent'))
            ->output();
    }

    /**
     * Show source.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function show(PublicRequest $request, $slug)
    {
        $model = Source::findBySlug($slug);
        $data = new SourceResource($model);

        $categories = [];
        $tags = [];
        $recent = [];
    
        return $this->response->setMetaTitle($data['title'] . trans('source::source.name'))
            ->view('source::public.source.show')
            ->data(compact('data', 'categories', 'tags', 'recent'))
            ->output();
    }

}
