<?php

namespace Bixo\Source\Http\Controllers;

use App\Http\Controllers\ActionController as BaseController;
use Exception;
use Bixo\Source\Actions\SourceReport;
use Bixo\Source\Http\Requests\SourceReportRequest;

/**
 * Admin web controller class.
 */
class SourceReportController extends BaseController
{
    /**
     * Action controller function for source.
     *
     * @param Model $model
     * @param action next action for the model.
     *
     * @return Response
     */
    public function __invoke(SourceReportRequest $request, $report)
    {
        try {
        
            $this->model = app(Source::class);
            $data = SourceReport::run($request, $report);

            return $this->response->message(trans('messages.success.updated', ['Module' => trans('source::source.name')]))
                ->code(204)
                ->data(compact('data'))
                ->status('success')
                ->url(guard_url('source/source/' . $report))
                ->redirect();
        } catch (Exception $e) {
            return $this->response->message($e->getMessage())
                ->code(400)
                ->status('error')
                ->url(guard_url('source/source/' . $report))
                ->redirect();
        }
    }
}
