<?php

namespace Bixo\Source\Http\Requests;

use Litepie\Http\Request\AbstractRequest;

class SourceActionRequest extends AbstractRequest
{

    /* Model for the current request.
     *
     * @var array
     */
    protected $action;

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        $this->model = $this->route('source');
        $this->action = $this->getAction();
        // Determine if the user is authorized to perform the action.
        return $this->can($this->action);

    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return config('litecms.source.source.action.role', []);
    }

}
