<?php

namespace Bixo\Source\Listeners;

use Illuminate\Support\Facades\Notification;
use Illuminate\Support\Str;
use Bixo\Source\Events\SourceAction as SourceActionEvent;
use Bixo\Source\Notifications\SourceAction as SourceActionNotification;
use Litepie\Actions\Concerns\AsAction;

class SourceAction
{
    use AsAction;

    private $allowedActions = [
        'before' => [],
        'after' => ['create'],
    ];

    /**
     * Handle the SourceActionEvent.
     *
     * @param   SourceActionEvent  $event
     * @return mixed
     */
    public function handle(SourceActionEvent $event)
    {
        $function = Str::camel($event->action);
        return $this->$function($event);
    }

    /**
     * Create a new $source.
     *
     * @param   SourceActionEvent  $event
     * @return void
     */
    public function create(SourceActionEvent $event)
    {
        $client = $event->source->client;
        Notification::send($client, new SourceActionNotification($event));
    }

    /**
     * Handle the SourceActionEvent as a listener.
     *
     * @param   SourceActionEvent  $event
     * @return mixed
     */
    public function asListener(SourceActionEvent $event)
    {
        if ($this->isAllowed($event)) {
            return $this->handle($event);
        }
    }

    /**
     * Check if the event action is allowed.
     *
     * @param   SourceActionEvent  $event
     * @return bool
     */
    private function isAllowed(SourceActionEvent $event)
    {
        if ($event->when == 'before' &&
            !in_array($event->action, $this->allowedActions['before'])) {
            return false;
        }

        if (($event->when == 'after' &&
            !in_array($event->action, $this->allowedActions['after']))
        ) {
            return false;
        }

        return true;
    }
}
