<?php
namespace Bixo\Source\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;
use Illuminate\Notifications\Notification;
use Bixo\Source\Events\SourceAction as SourceActionEvent;
use Bixo\Source\Models\Source;

class SourceAction extends Notification implements ShouldQueue
{
    use Queueable;

    protected $event;
    protected $source;
    protected $action;
    protected $request;

    /**
     * Create a new notification instance.
     *
     * @param SourceActionEvent $source
     */
    public function __construct(SourceActionEvent $source)
    {
        $this->action = $event->action;
        $this->source = $source;
        $this->request = $event->request;
        $this->event = $event;

    }

    /**
     * Get the mail representation of the notification.
     *
     * @param mixed $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        return (new MailMessage)
            ->subject('Source Approved - ' . config('app.name'))
            ->view('source::source.email.action', ['data' => $this->source]);
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param object $notifiable
     * @return array<int, string>
     */
    public function via(object $notifiable): array
    {
        return ['mail'];
    }
}
