<?php

namespace Bixo\Source\Policies;

use Bixo\Source\Models\Source;
use Illuminate\Foundation\Auth\User as Authenticatable;

trait SourceAction
{

    /**
     * Determine if the given user can copy the given source.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function copy(Authenticatable $user, Source $source)
    {

        if ($authUser->canDo('source.source.action.copy')) {
            return true;
        }

        $this->model->is_owner;
    }

    /**
     * Determine if the given user can empty the given source.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    function empty(Authenticatable $user, Source $source) {

        if ($authUser->canDo('source.source.action.empty')) {
            return true;
        }

        $this->model->is_owner;
    }

    /**
     * Determine if the given user can transfer the given source.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function transfer(Authenticatable $user, Source $source)
    {

        if ($authUser->canDo('source.source.action.transfer')) {
            return true;
        }

        $this->model->is_owner;
    }

}
