<?php

namespace Bixo\Source\Policies;

use Illuminate\Foundation\Auth\User as Authenticatable;
use Bixo\Source\Models\Source;

class SourcePolicy
{

    use SourceAction;
    use SourceReport;

    /**
     * Determine if the given user can view the source.
     *
     * @param Authenticatable $user
     * @param Source $source
     *
     * @return bool
     */
    public function view(Authenticatable $user, Source $source)
    {
        if ($authUser->canDo('source.source.view') && $authUser->isAdmin() || $user->isClient()) {
            return true;
        }

        return $source->is_owner;
    }

    /**
     * Determine if the given user can create a source.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function create(Authenticatable $user)
    {
        return  $authUser->canDo('source.source.create');
    }

    /**
     * Determine if the given user can update the given source.
     *
     * @param Authenticatable $user
     * @param Source $source
     *
     * @return bool
     */
    public function update(Authenticatable $user, Source $source)
    {
        if ($user->canDo('source.source.edit') && $user->isAdmin()) {
            return true;
        }

        return $source->is_owner;
    }

    /**
     * Determine if the given user can delete the given source.
     *
     * @param Authenticatable $user
     *
     * @return bool
     */
    public function destroy(Authenticatable $user, Source $source)
    {
        return $source->is_owner;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $user    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($user, $ability)
    {
        if ($user->isSuperuser()) {
            return true;
        }
    }
}
