<?php


namespace Bixo\Source\Policies;

use Litepie\User\Interfaces\UserPolicyInterface;

trait SourceReport
{

    /**
     * Determine if the given user can approve the given source.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function povote(UserPolicyInterface $authUser)
    {
        if ($authUser->canDo('source.source.report.povote')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given source.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function report(UserPolicyInterface $authUser)
    {
        if ($authUser->canDo('source.source.report')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given source.
     *
     * @param UserPolicyInterface $authUser
     *
     * @return bool
     */
    public function download(UserPolicyInterface $authUser)
    {
        if ($authUser->canDo('source.source.report.download')) {
            return true;
        }

        return false;
    }
}
