<?php

namespace Bixo\Source\Providers;

use Illuminate\Foundation\Support\Providers\EventServiceProvider as ServiceProvider;
use Bixo\Source\Events\SourceAction;
use Bixo\Source\Events\SourceWorkflow;
use Bixo\Source\Listeners\SourceAction as SourceActionListener;
use Bixo\Source\Listeners\SourceWorkflow as SourceWorkflowListener;


class EventServiceProvider extends ServiceProvider
{
    /**
     * The event listener mappings for the application.
     *
     * @var array
     */
    protected $listen = [
    
        SourceAction::class => [
            SourceActionListener::class,
        ],
        SourceWorkflow::class => [
            SourceWorkflowListener::class,
        ],
    ];

    /**
     * Register any other events for your application.
     *
     * @param \Illuminate\Contracts\Events\Dispatcher $events
     *
     * @return void
     */
    public function boot()
    {
        parent::boot();

        //
    }
}
