<?php

namespace Bixo\Source\Providers;

use Illuminate\Support\ServiceProvider;
use Bixo\Source\Sources;

class SourceServiceProvider extends ServiceProvider
{
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = true;

    /**
     * Bootstrap the application events.
     *
     * @return void
     */
    public function boot()
    {
        // Load view
        $this->loadViewsFrom(__DIR__ . '/../../resources/views', 'source');

        // Load translation
        $this->loadTranslationsFrom(__DIR__ . '/../../resources/lang', 'source');

        // Load migrations
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');

        // Call pblish redources function
        $this->publishResources();

    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        $this->mergeConfig();
        $this->registerFacade();

        $this->app->register(\Bixo\Source\Providers\AuthServiceProvider::class);
        $this->app->register(\Bixo\Source\Providers\RouteServiceProvider::class);
        $this->app->register(\Bixo\Source\Providers\ActionServiceProvider::class);
        $this->app->register(\Bixo\Source\Providers\EventServiceProvider::class);
    }

    /**
     * Register the vault facade without the user having to add it to the app.php file.
     *
     * @return void
     */
    public function registerFacade() {
        $this->app->bind('bixo.source', function($app)
        {
            return $this->app->make(Source::class);
        });
    }

    /**
     * Merges user's and source's configs.
     *
     * @return void
     */
    protected function mergeConfig()
    {
        $this->mergeConfigFrom(
            __DIR__ . '/../../config/config.php', 'bixo.source'
        );
        
        
        $this->mergeConfigFrom(
            __DIR__ . '/../../config/source.php', 'bixo.source.source'
        );
    }


    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return ['bixo.source'];
    }

    /**
     * Publish resources.
     *
     * @return void
     */
    private function publishResources()
    {
        // Publish configuration file
        $this->publishes([__DIR__ . '/../../config/' => config_path('bixo/source')], 'config');

        // Publish admin view
        $this->publishes([__DIR__ . '/../../resources/views' => base_path('resources/views/vendor/source')], 'view');

        // Publish language files
        $this->publishes([__DIR__ . '/../../resources/lang' => base_path('resources/lang/vendor/source')], 'lang');

        // Publish public files and assets.
        $this->publishes([__DIR__ . '/public/' => public_path('/')], 'public');
    }
}
