<?php

return [

    /**
     * Provider.
     */
    'provider'  => 'liteerp',

    /*
     * Package.
     */
    'package'   => 'source',

    /*
     * Modules.
     */
    'modules'   => ['source'],

    
    'source'       => [
        'model' => [
            'model'                 => \Liteerp\Source\Models\Source::class,
            'table'                 => 'sources',
            'presenter'             => \Liteerp\Source\Repositories\Presenter\SourcePresenter::class,
            'hidden'                => [],
            'visible'               => [],
            'guarded'               => ['*'],
            'slugs'                 => ['slug' => 'name'],
            'dates'                 => ['deleted_at', 'createdat', 'updated_at'],
            'appends'               => [],
            'fillable'              => ['id',  'name',  'slug',  'description',  'deleted_at',  'created_at',  'updated_at'],
            'translatables'         => [],
            'upload_folder'         => 'source/source',
            'uploads'               => [
            /*
                    'images' => [
                        'count' => 10,
                        'type'  => 'image',
                    ],
                    'file' => [
                        'count' => 1,
                        'type'  => 'file',
                    ],
            */
            ],

            'casts'                 => [
            /*
                'images'    => 'array',
                'file'      => 'array',
            */
            ],

            'revision'              => [],
            'perPage'               => '20',
            'search'        => [
                'name'  => 'like',
                'status',
            ]
        ],

        'controller' => [
            'provider'  => 'Liteerp',
            'package'   => 'Source',
            'module'    => 'Source',
        ],

    ],
];
