<?php

namespace Liteerp\Source\Http\Controllers;

use App\Http\Controllers\PublicController as BaseController;
use Liteerp\Source\Interfaces\SourceRepositoryInterface;

class SourcePublicController extends BaseController
{
    // use SourceWorkflow;

    /**
     * Constructor.
     *
     * @param type \Liteerp\Source\Interfaces\SourceRepositoryInterface $source
     *
     * @return type
     */
    public function __construct(SourceRepositoryInterface $source)
    {
        $this->repository = $source;
        parent::__construct();
    }

    /**
     * Show source's list.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function index()
    {
        $sources = $this->repository
        ->pushCriteria(app('Litepie\Repository\Criteria\RequestCriteria'))
        ->scopeQuery(function($query){
            return $query->orderBy('id','DESC');
        })->paginate();


        return $this->response->title(trans('$source::$source.names'))
            ->view('$source::public.source.index')
            ->data(compact('$sources'))
            ->output();
    }

    /**
     * Show source's list based on a type.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function list($type = null)
    {
        $sources = $this->repository
        ->pushCriteria(app('Litepie\Repository\Criteria\RequestCriteria'))
        ->scopeQuery(function($query){
            return $query->orderBy('id','DESC');
        })->paginate();


        return $this->response->title(trans('$source::$source.names'))
            ->view('$source::public.source.index')
            ->data(compact('$sources'))
            ->output();
    }

    /**
     * Show source.
     *
     * @param string $slug
     *
     * @return response
     */
    protected function show($slug)
    {
        $source = $this->repository->scopeQuery(function($query) use ($slug) {
            return $query->orderBy('id','DESC')
                         ->where('slug', $slug);
        })->first(['*']);

        return $this->response->title($$source->name . trans('$source::$source.name'))
            ->view('$source::public.source.show')
            ->data(compact('$source'))
            ->output();
    }

}
