<?php

namespace Liteerp\Source\Policies;

use Litepie\User\Contracts\UserPolicy;
use Liteerp\Source\Models\Source;

class SourcePolicy
{

    /**
     * Determine if the given user can view the source.
     *
     * @param UserPolicy $user
     * @param Source $source
     *
     * @return bool
     */
    public function view(UserPolicy $user, Source $source)
    {
        if ($user->canDo('source.source.view') && $user->isAdmin()) {
            return true;
        }

        return $source->user_id == user_id() && $source->user_type == user_type();
    }

    /**
     * Determine if the given user can create a source.
     *
     * @param UserPolicy $user
     * @param Source $source
     *
     * @return bool
     */
    public function create(UserPolicy $user)
    {
        return  $user->canDo('source.source.create');
    }

    /**
     * Determine if the given user can update the given source.
     *
     * @param UserPolicy $user
     * @param Source $source
     *
     * @return bool
     */
    public function update(UserPolicy $user, Source $source)
    {
        if ($user->canDo('source.source.edit') && $user->isAdmin()) {
            return true;
        }

        return $source->user_id == user_id() && $source->user_type == user_type();
    }

    /**
     * Determine if the given user can delete the given source.
     *
     * @param UserPolicy $user
     * @param Source $source
     *
     * @return bool
     */
    public function destroy(UserPolicy $user, Source $source)
    {
        return $source->user_id == user_id() && $source->user_type == user_type();
    }

    /**
     * Determine if the given user can verify the given source.
     *
     * @param UserPolicy $user
     * @param Source $source
     *
     * @return bool
     */
    public function verify(UserPolicy $user, Source $source)
    {
        if ($user->canDo('source.source.verify')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the given user can approve the given source.
     *
     * @param UserPolicy $user
     * @param Source $source
     *
     * @return bool
     */
    public function approve(UserPolicy $user, Source $source)
    {
        if ($user->canDo('source.source.approve')) {
            return true;
        }

        return false;
    }

    /**
     * Determine if the user can perform a given action ve.
     *
     * @param [type] $user    [description]
     * @param [type] $ability [description]
     *
     * @return [type] [description]
     */
    public function before($user, $ability)
    {
        if ($user->isSuperuser()) {
            return true;
        }
    }
}
