<?php

namespace Liteerp\Source\Providers;

use Illuminate\Support\ServiceProvider;

class SourceServiceProvider extends ServiceProvider
{
    /**
     * Indicates if loading of the provider is deferred.
     *
     * @var bool
     */
    protected $defer = false;

    /**
     * Bootstrap the application events.
     *
     * @return void
     */
    public function boot()
    {
        // Load view
        $this->loadViewsFrom(__DIR__ . '/../../resources/views', 'source');

        // Load translation
        $this->loadTranslationsFrom(__DIR__ . '/../../resources/lang', 'source');

        // Load migrations
        $this->loadMigrationsFrom(__DIR__ . '/../../database/migrations');

        // Call pblish redources function
        $this->publishResources();

    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        // Bind facade
        $this->app->bind('liteerp.source', function ($app) {
            return $this->app->make('Liteerp\Source\Source');
        });

                // Bind Source to repository
        $this->app->bind(
            'Liteerp\Source\Interfaces\SourceRepositoryInterface',
            \Liteerp\Source\Repositories\Eloquent\SourceRepository::class
        );

        $this->app->register(\Liteerp\Source\Providers\AuthServiceProvider::class);
        
        $this->app->register(\Liteerp\Source\Providers\RouteServiceProvider::class);
                
    }

    /**
     * Get the services provided by the provider.
     *
     * @return array
     */
    public function provides()
    {
        return ['liteerp.source'];
    }

    /**
     * Publish resources.
     *
     * @return void
     */
    private function publishResources()
    {
        // Publish configuration file
        $this->publishes([__DIR__ . '/../../config/config.php' => config_path('liteerp/source.php')], 'config');

        // Publish admin view
        $this->publishes([__DIR__ . '/../../resources/views' => base_path('resources/views/vendor/source')], 'view');

        // Publish language files
        $this->publishes([__DIR__ . '/../../resources/lang' => base_path('resources/lang/vendor/source')], 'lang');

        // Publish public files and assets.
        $this->publishes([__DIR__ . '/public/' => public_path('/')], 'public');
    }
}
