<?php

namespace Liteerp\Source\Repositories\Presenter;

use League\Fractal\TransformerAbstract;
use Hashids;

class SourceTransformer extends TransformerAbstract
{
    public function transform(\Liteerp\Source\Models\Source $source)
    {
        return [
            'id'                => $source->getRouteKey(),
            'key'               => [
                'public'    => $source->getPublicKey(),
                'route'     => $source->getRouteKey(),
            ], 
            'id'                => $source->id,
            'name'              => $source->name,
            'slug'              => $source->slug,
            'description'       => $source->description,
            'deleted_at'        => $source->deleted_at,
            'created_at'        => $source->created_at,
            'updated_at'        => $source->updated_at,
            'url'               => [
                'public'    => trans_url('source/'.$source->getPublicKey()),
                'user'      => guard_url('source/source/'.$source->getRouteKey()),
            ], 
            'status'            => trans('app.'.$source->status),
            'created_at'        => format_date($source->created_at),
            'updated_at'        => format_date($source->updated_at),
        ];
    }
}