<?php

namespace Liteerp\Source;

use User;

class Source
{
    /**
     * $source object.
     */
    protected $source;

    /**
     * Constructor.
     */
    public function __construct(\Liteerp\Source\Interfaces\SourceRepositoryInterface $source)
    {
        $this->source = $source;
    }

    /**
     * Returns count of source.
     *
     * @param array $filter
     *
     * @return int
     */
    public function count()
    {
        return  0;
    }

    /**
     * Make gadget View
     *
     * @param string $view
     *
     * @param int $count
     *
     * @return View
     */
    public function gadget($view = 'admin.source.gadget', $count = 10)
    {

        if (User::hasRole('user')) {
            $this->source->pushCriteria(new \Litepie\Liteerp\Repositories\Criteria\SourceUserCriteria());
        }

        $source = $this->source->scopeQuery(function ($query) use ($count) {
            return $query->orderBy('id', 'DESC')->take($count);
        })->all();

        return view('source::' . $view, compact('source'))->render();
    }
}
